/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.tasklet;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemManager;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemResolutionException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.service.serviceaction.MultipleInstancePolicy;
import com.ibm.hwmca.fw.service.serviceaction.MultipleInstancePolicyFactory;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitorFactory;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionFactory;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.tasklet.SynchronousPanelTasklet;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.repair.utils.XRVLog;
import com.ibm.hwmca.xfw.service.PETrace;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFruFilter;
import com.ibm.hwmca.xfw.service.panel.PBSingleServiceActionRestriction;
import com.ibm.hwmca.xfw.service.tasklet.SyncTaskletGuiWrapperImpl;
import com.ibm.hwmca.xfw.service.utils.RVCommonLogging;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RepairAndVerifyTasklet
extends SynchronousPanelTasklet {
    private static final String TRACE_MASKT = "XRVR&V_T";
    private static final String TRACE_MASKF = "XRVR&V_F";
    private static final String TRACE_MASKD = "XRVR&V_D";
    private static final int MAX_RV_TRACE_SIZE = 100000;
    private static final int MAX_RV_TRACE_FILES = 5;
    private static final String RV_TRACE_FILE = "data/service/RVTrace_";
    private static Object lockObject = new Object();
    private static List activeServiceActions = new ArrayList();
    private GenericGui guiInterfaceImpl = null;
    public static final String SYSTEM_MTMS_KEY = "SYSTEM_MTMS";
    public static final String LOCATIONS_KEY = "LOCATIONS";
    public static final String FRU_IDS_KEY = "FRU_IDS";
    public static final String PROBLEM_NUMBER_KEY = "problemNumber";
    public static final String ANALYZING_MTMS_KEY = "analyzingMTMS";
    private ManagedSystem ms = null;
    private String managedSystemMTMS = null;
    private String msType;
    private String msModel;
    private String msSerial;
    private String problemNumberString = null;
    private String saType;
    private String formattedServiceActionName;
    boolean utilityMode = false;
    private String[] fruIds = null;
    private String[] locations = null;

    public RepairAndVerifyTasklet() {
        Trace.trace(TRACE_MASKT, "<> RepairAndVerifyTasklet ctor");
        this.guiInterfaceImpl = new SyncTaskletGuiWrapperImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLogic() {
        block32: {
            Map userData;
            block30: {
                Trace.trace(TRACE_MASKT, "-> RepairAndVerifyTasklet.businessLogic");
                userData = (Map)this.getRedirectData();
                try {
                    try {
                        Object object;
                        int aii;
                        String savetype = this.saType = (String)userData.get("rvType");
                        this.overrideServiceActionType();
                        if (savetype != this.saType) {
                            userData.put("rvType", this.saType);
                        }
                        String traceFilePath = System.getProperty("CONSOLE_PATH") + RV_TRACE_FILE + this.saType;
                        PETrace.start(userData, traceFilePath, 100000, 5);
                        this.locations = (String[])userData.get(LOCATIONS_KEY);
                        this.fruIds = (String[])userData.get(FRU_IDS_KEY);
                        this.managedSystemMTMS = (String)userData.get(SYSTEM_MTMS_KEY);
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic input key settings:");
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic FConstants.ACTION_TYPE_KEY(String)=" + this.saType);
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic LOCATIONS_KEY(String[])=" + this.locations);
                        if (this.locations != null) {
                            for (aii = 0; aii < this.locations.length; ++aii) {
                                Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic locations[" + aii + "]=" + this.locations[aii]);
                            }
                        }
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic FRU_IDS_KEY(String[])=" + this.fruIds);
                        if (this.fruIds != null) {
                            for (aii = 0; aii < this.fruIds.length; ++aii) {
                                Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic fruIds[" + aii + "]=" + this.fruIds[aii]);
                            }
                        }
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic SYSTEM_MTMS_KEY(String)=" + this.managedSystemMTMS);
                        userData.put("DISPLAY_HANDLE", this.guiInterfaceImpl);
                        ServiceAction sa = this.resolveServiceAction(userData);
                        HashMap<String, Object> subs = new HashMap<String, Object>();
                        subs.put("formattedServiceActionName", this.formattedServiceActionName);
                        subs.put("locations", this.locations);
                        subs.put("msType", this.msType);
                        subs.put("msModel", this.msModel);
                        subs.put("msSerial", this.msSerial);
                        subs.put("problemNumberString", this.problemNumberString);
                        subs.put("timeStarted", Calendar.getInstance().getTime().toString());
                        boolean allowServiceAction = true;
                        Map activeMap = null;
                        try {
                            Object object2 = lockObject;
                            synchronized (object2) {
                                if (activeServiceActions.size() > 0) {
                                    try {
                                        MultipleInstancePolicy mip;
                                        MultipleInstancePolicyFactory mipf = (MultipleInstancePolicyFactory)ServiceInterfaces.getFactory(sa, "MultipleInstancePolicyFactory");
                                        if (mipf != null && (mip = mipf.create()) != null && !mip.allowMultiples()) {
                                            activeMap = (Map)activeServiceActions.get(0);
                                            allowServiceAction = false;
                                        }
                                    }
                                    catch (ServiceInterfacesException toss) {
                                        allowServiceAction = true;
                                        activeServiceActions.clear();
                                    }
                                }
                            }
                            try {
                                ProblemMonitorFactory pmf;
                                ProblemMonitor pm2;
                                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                                if (ms != null && (pm2 = (pmf = (ProblemMonitorFactory)ms.getFactory("ProblemMonitorFactory")).create(userData)) != null) {
                                    userData.put("PROBLEM_MONITOR", pm2);
                                    Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic ProblemMonitor created and set");
                                }
                            }
                            catch (Exception toss) {
                                // empty catch block
                            }
                            if (allowServiceAction) {
                                activeServiceActions.add(subs);
                                PETrace.petrace(userData, "resolved ServiceAction:  " + sa.getClass().getName());
                                sa.start(userData);
                                PETrace.petrace(userData, "ServiceAction completed");
                            } else {
                                PETrace.petrace(userData, "resolved ServiceAction:  " + sa.getClass().getName() + " NOT started");
                                PBSingleServiceActionRestriction bean = new PBSingleServiceActionRestriction();
                                bean.setDataMap(activeMap);
                                this.guiInterfaceImpl.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                            }
                            Object var13_15 = null;
                            object = lockObject;
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            Object object2 = lockObject;
                            synchronized (object2) {
                                if (allowServiceAction) {
                                    activeServiceActions.remove(subs);
                                }
                                throw throwable;
                            }
                        }
                        synchronized (object) {
                            if (allowServiceAction) {
                                activeServiceActions.remove(subs);
                            }
                        }
                        Object var17_20 = null;
                        if (userData == null) break block30;
                    }
                    catch (Throwable e) {
                        ProblemMonitor pm322;
                        PETrace.petrace(userData, "exception caught and logged: " + e);
                        PETrace.petrace(userData, e);
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.businessLogic Exception caught: " + e);
                        Trace.trace(TRACE_MASKF, e);
                        this.logException(e);
                        Object var17_21 = null;
                        if (userData != null && (pm322 = (ProblemMonitor)userData.get("PROBLEM_MONITOR")) != null) {
                            PETrace.petrace(userData, "turning off PA problem monitoring");
                            pm322.stop();
                        }
                        PETrace.stop(userData);
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    ProblemMonitor pm322;
                    Object var17_22 = null;
                    if (userData != null && (pm322 = (ProblemMonitor)userData.get("PROBLEM_MONITOR")) != null) {
                        PETrace.petrace(userData, "turning off PA problem monitoring");
                        pm322.stop();
                    }
                    PETrace.stop(userData);
                    throw throwable;
                }
                ProblemMonitor pm322 = (ProblemMonitor)userData.get("PROBLEM_MONITOR");
                if (pm322 != null) {
                    PETrace.petrace(userData, "turning off PA problem monitoring");
                    pm322.stop();
                }
            }
            PETrace.stop(userData);
        }
        Trace.trace(TRACE_MASKT, "<- RepairAndVerifyTasklet.businessLogic");
        this.terminate(false);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "<> RepairAndVerifyTasklet.logException; throwable[" + throwable + "]");
        Trace.trace(TRACE_MASKT, throwable);
        if (throwable instanceof HException) {
            XRVLog.logit((short)1, throwable);
        } else {
            XRVLog.logit((short)2, throwable);
        }
        RVCommonLogging.logAvailableTraceInfo("Exception caught in RepairAndVerifyTasklet", throwable);
    }

    private ServiceAction resolveServiceAction(Map userData) throws HException {
        boolean powerOnOff = false;
        Trace.trace(TRACE_MASKF, "-> RepairAndVerifyTasklet.businessLogic action key value: " + this.saType);
        ServiceableEvent se = null;
        ProblemManager sem = null;
        ServiceAction sa = null;
        ServiceActionType sat = null;
        if (this.saType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || this.saType.equals("OPEN_PROBLEM")) {
            this.formattedServiceActionName = "Problem Repair";
            sat = ServiceActionType.REPAIR_PROBLEM;
            sem = ProblemManager.getProblemManager();
            this.problemNumberString = (String)userData.get(PROBLEM_NUMBER_KEY);
            int problemNumber = Integer.parseInt(this.problemNumberString);
            String analyzingMTMS = (String)userData.get(ANALYZING_MTMS_KEY);
            List problems = sem.getAllProblems();
            Iterator it = problems.iterator();
            boolean found = false;
            ServiceableEvent lastMatch = null;
            while (it.hasNext() && !found) {
                String consoleSystemMTMS;
                PASystem pas;
                se = (ServiceableEvent)it.next();
                if (((Problem)se).getProblemState() == 2 || ((Problem)se).getProblemNumber() != problemNumber) continue;
                lastMatch = se;
                if (!(se instanceof CommonProblem) || analyzingMTMS == null || (pas = ((CommonProblem)se).getPrimaryAnalyzingConsoleSystem()) == null || (consoleSystemMTMS = pas.getMTMS()) == null || !consoleSystemMTMS.equals(analyzingMTMS)) continue;
                found = true;
            }
            if (!found) {
                if (lastMatch == null) {
                    PETrace.petrace(userData, "unknown problem number: " + problemNumber);
                    Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction unknown problem number[" + problemNumber + "]");
                    throw new HException("unknown problem number[" + problemNumber + "]");
                }
                if (analyzingMTMS == null) {
                    se = lastMatch;
                } else {
                    PETrace.petrace(userData, "unknown problem number: " + problemNumber + " from analyzing system: " + analyzingMTMS);
                    Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction unknown problem number: " + problemNumber + " from analyzing system: " + analyzingMTMS);
                    throw new HException("unknown problem number: " + problemNumber + " from analyzing system: " + analyzingMTMS);
                }
            }
            PASystem reportingSystem = ((CommonProblem)se).getReportingRemoteMachineSystem();
            PASystem failingSystem = ((CommonProblem)se).getFailingSystem();
            PASystem pas = reportingSystem == null ? failingSystem : reportingSystem;
            for (int aii = 0; aii < 2; ++aii) {
                try {
                    if (pas == null) {
                        PETrace.petrace(userData, "problem number[" + problemNumber + "] does not contain a PASystem object");
                        Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction problem number[" + problemNumber + "] does not contain a PASystem object");
                        throw new HException("problem number[" + problemNumber + "] does not contain a PASystem object");
                    }
                    this.msType = pas.getMachineType();
                    this.msModel = pas.getMachineModel();
                    this.msSerial = pas.getMachineSerial();
                    this.ms = ManagedSystemManager.getManager().getManagedSystem(this.msType, this.msModel, this.msSerial);
                    break;
                }
                catch (ManagedSystemResolutionException e) {
                    if (pas != reportingSystem) {
                        PETrace.petrace(userData, "managed system cannot be resolved for failingSystem; type[" + this.msType + "],model[" + this.msModel + "]");
                        Trace.trace(TRACE_MASKT, "!!! RepairAndVerifyTasklet.resolveServiceAction managed system cannot be resolved for failingSystem; type[" + this.msType + "],model[" + this.msModel + "]");
                        break;
                    }
                    PETrace.petrace(userData, "managed system cannot be resolved for reportingSystem; type[" + this.msType + "],model[" + this.msModel + "], trying failingSystem");
                    Trace.trace(TRACE_MASKT, "!!! RepairAndVerifyTasklet.resolveServiceAction managed system cannot be resolved for reportingSystem; type[" + this.msType + "],model[" + this.msModel + "], trying failingSystem");
                    pas = failingSystem;
                    continue;
                }
            }
            this.overrideSystem();
            if (this.msType == null || this.msModel == null || this.msSerial == null) {
                Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction incomplete machine type/model/serial info in PASystem object in problem number[" + problemNumber + "]");
                throw new HException("incomplete machine type/model/serial info in PASystem object in problem number[" + problemNumber + "]");
            }
            Trace.trace(TRACE_MASKD, "RepairAndVerifyTasklet.resolveServiceAction problem number[" + problemNumber + "] found.  Reporting system type|model|serial:" + this.msType + "|" + this.msModel + "|" + this.msSerial);
        } else {
            Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.resolveServiceAction managed system MTMS: " + this.managedSystemMTMS);
            if (this.managedSystemMTMS == null) {
                this.managedSystemMTMS = "tttt-mmm/sssssss";
            }
            if (this.managedSystemMTMS == null) {
                Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction for action type[" + this.saType + "], required input key[" + SYSTEM_MTMS_KEY + "] is not specified");
                throw new HException("for action type[" + this.saType + "], required input key[" + SYSTEM_MTMS_KEY + "] is not specified");
            }
            int[] delims = new int[2];
            int delimIndex = 0;
            for (int aii = 0; aii < this.managedSystemMTMS.length() && delimIndex < 2; ++aii) {
                if (Character.isLetterOrDigit(this.managedSystemMTMS.charAt(aii))) continue;
                delims[delimIndex++] = aii;
            }
            if (delimIndex != 2) {
                Trace.trace(TRACE_MASKT, "<-! RepairAndVerifyTasklet.resolveServiceAction passed system MTMS[" + this.managedSystemMTMS + "] not a supported format");
                throw new HException("passed system MTMS[" + this.managedSystemMTMS + "] not a supported format");
            }
            this.msType = this.managedSystemMTMS.substring(0, delims[0]);
            this.msModel = this.managedSystemMTMS.substring(delims[0] + 1, delims[1]);
            this.msSerial = this.managedSystemMTMS.substring(delims[1] + 1);
            se = new CommonProblem();
            this.overrideSystem();
            userData.put("UTILITY_MODE", Boolean.FALSE);
            this.utilityMode = false;
            if (this.saType.equals(ServiceActionType.REPLACE_FRU.getValue())) {
                sat = ServiceActionType.REPLACE_FRU;
                this.formattedServiceActionName = "Replace FRU";
            } else if (this.saType.equals(ServiceActionType.REPLACE_ENCLOSURE.getValue())) {
                sat = ServiceActionType.REPLACE_ENCLOSURE;
                this.formattedServiceActionName = "Replace Enclosure";
            } else if (this.saType.equals(ServiceActionType.MES_INSTALL_FRU.getValue())) {
                sat = ServiceActionType.MES_INSTALL_FRU;
                this.formattedServiceActionName = "Install FRU";
            } else if (this.saType.equals(ServiceActionType.MES_INSTALL_ENCLOSURE.getValue())) {
                sat = ServiceActionType.MES_INSTALL_ENCLOSURE;
                this.formattedServiceActionName = "Install Enclosure";
            } else if (this.saType.equals(ServiceActionType.MES_REMOVE_FRU.getValue())) {
                sat = ServiceActionType.MES_REMOVE_FRU;
                this.formattedServiceActionName = "Remove FRU";
            } else if (this.saType.equals(ServiceActionType.MES_REMOVE_ENCLOSURE.getValue())) {
                sat = ServiceActionType.MES_REMOVE_ENCLOSURE;
                this.formattedServiceActionName = "Remove Enclosure";
            } else if (this.saType.equals(ServiceActionType.POWER_OFF.getValue())) {
                sat = ServiceActionType.POWER_OFF;
                this.formattedServiceActionName = "Power OFF";
                userData.put("UTILITY_MODE", Boolean.TRUE);
                this.utilityMode = true;
                powerOnOff = true;
            } else if (this.saType.equals(ServiceActionType.POWER_ON.getValue())) {
                sat = ServiceActionType.POWER_ON;
                this.formattedServiceActionName = "Power ON";
                userData.put("UTILITY_MODE", Boolean.TRUE);
                this.utilityMode = true;
                powerOnOff = true;
            } else {
                this.utilityMode = true;
                userData.put("UTILITY_MODE", Boolean.TRUE);
                this.formattedServiceActionName = "Utility - " + this.saType;
            }
            this.addFrus(se);
        }
        try {
            this.ms = ManagedSystemManager.getManager().getManagedSystem(this.msType, this.msModel, this.msSerial);
        }
        catch (ManagedSystemResolutionException e) {
            PETrace.petrace(userData, "managed system cannot be resolved for mtm; type[" + this.msType + "],model[" + this.msModel + "], trying default... mtms (****.***)");
            Trace.trace(TRACE_MASKT, "!!! RepairAndVerifyTasklet.resolveServiceAction managed system cannot be resolved for mtm; type[" + this.msType + "],model[" + this.msModel + "], trying default... mtms (****.***)");
            this.ms = ManagedSystemManager.getManager().getManagedSystem("****", "***", "*******");
        }
        userData.put("MANAGED_SYSTEM_TYPE", this.msType);
        userData.put("MANAGED_SYSTEM_MODEL", this.msModel);
        userData.put("MANAGED_SYSTEM_SERIAL", this.msSerial);
        userData.put("PROBLEM", se);
        userData.put("SERVICEABLE_EVENT", se);
        userData.put("FORMATTED_SERVICE_ACTION_NAME", this.formattedServiceActionName);
        if (this.utilityMode && !powerOnOff) {
            Trace.trace(TRACE_MASKT, "RepairAndVerifyTasklet.resolveServiceAction **utility mode*** type[" + this.saType + "]");
            sa = new Utility();
        } else {
            sa = se.getServiceAction();
            if (sa == null) {
                ServiceActionFactory saf = (ServiceActionFactory)this.ms.getFactory("ServiceActionFactory");
                sa = saf.create(sat, userData);
                se.setServiceAction(sa);
                if (sem != null) {
                    sem.changed(se);
                }
                ((CommonProblem)se).serviceHistoryEvent(new HistoryEntry(4));
            } else {
                ((CommonProblem)se).serviceHistoryEvent(new HistoryEntry(8));
            }
        }
        userData.put("MANAGED_SYSTEM", this.ms);
        this.overrideFruList((CommonProblem)se);
        return sa;
    }

    private void overrideFruList(CommonProblem problem) throws HException {
        File f = new File("/tmp/problemdata.properties");
        if (!f.exists()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream("/tmp/problemdata.properties");
            Properties props = new Properties();
            props.load(is);
            problem.removeFruList();
            int index = Integer.parseInt(props.getProperty("index"));
            CommonPaFru cpf = new CommonPaFru();
            PASystem pas = new PASystem();
            cpf.setEnclosureSystem(pas);
            pas.setMachineType(props.getProperty("enclosure.type." + index));
            pas.setMachineModel(props.getProperty("enclosure.model." + index));
            pas.setMachineSerial(props.getProperty("enclosure.serial." + index));
            cpf.setId(props.getProperty("id." + index));
            cpf.addLocation(props.getProperty("location." + index));
            problem.addPart(cpf);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.simulateRequest error processing /tmp/problemdata.properties - ignoring");
        }
    }

    private void overrideSystem() throws HException {
        File f = new File("/tmp/problemdata.properties");
        if (!f.exists()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream("/tmp/problemdata.properties");
            Properties props = new Properties();
            props.load(is);
            this.msType = props.getProperty("system.type");
            this.msModel = props.getProperty("system.model");
            this.msSerial = props.getProperty("system.serial");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.simulateRequest error processing /tmp/problemdata.properties - ignoring");
        }
    }

    private void addFrus(ServiceableEvent se) throws HException {
        if (se instanceof CommonProblem) {
            CommonProblem cp = (CommonProblem)se;
            if (this.locations != null) {
                if (this.fruIds != null && this.fruIds.length != this.locations.length) {
                    Trace.trace(TRACE_MASKF, "<-! RepairAndVerifyTasklet.addFrus, input LOCATIONS array not a 1-1 match in size with input FRU_IDS array");
                    throw new HException("input LOCATIONS array not a 1-1 size match with input FRU_IDS array");
                }
                for (int aii = 0; aii < this.locations.length; ++aii) {
                    int dash;
                    int firstDot;
                    int nextDot;
                    CommonPaFru cpf = new CommonPaFru();
                    if (this.fruIds != null) {
                        cpf.setId(this.fruIds[aii]);
                    }
                    if (this.utilityMode) {
                        cpf.setId("UTILITY_MODE");
                    }
                    if ((nextDot = this.locations[aii].indexOf(46, (firstDot = this.locations[aii].indexOf(46)) + 1)) == -1) {
                        int n = aii;
                        this.locations[n] = this.locations[n] + ".__TMP__";
                        Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.addFrus specified location[" + this.locations[aii] + "] has no serial - adding '.__TMP__' to complete the location code format");
                        nextDot = this.locations[aii].indexOf(46, firstDot + 1);
                    }
                    if ((dash = this.locations[aii].indexOf(45)) == -1) {
                        dash = this.locations[aii].length();
                    }
                    cpf.addLocation(this.locations[aii]);
                    PASystem pas = new PASystem();
                    cpf.setEnclosureSystem(pas);
                    pas.setMachineType(this.locations[aii].substring(1, firstDot));
                    pas.setMachineModel(this.locations[aii].substring(firstDot + 1, nextDot));
                    if (dash == -1) {
                        pas.setMachineSerial(this.locations[aii].substring(nextDot + 1));
                    } else {
                        pas.setMachineSerial(this.locations[aii].substring(nextDot + 1, dash));
                    }
                    cp.addPart(cpf);
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "RepairAndVerifyTasklet.addFrus, input ServiceableEvent not a CommonProblem??? NO-OP");
        }
    }

    private void overrideServiceActionType() {
        File f = new File("/tmp/problemdata.properties");
        if (!f.exists()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream("/tmp/problemdata.properties");
            Properties props = new Properties();
            props.load(is);
            this.saType = props.getProperty("serviceaction.type");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Utility
    extends ServiceAction {
        private Utility() {
        }

        public void start(Map userData) throws ServiceActionException {
            Trace.trace(RepairAndVerifyTasklet.TRACE_MASKF, "RepairAndVerifyTasklet.Utility.start for action: " + RepairAndVerifyTasklet.this.saType);
            ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
            CommonProblem cp = (CommonProblem)userData.get("SERVICEABLE_EVENT");
            DefaultFruFilter dff = new DefaultFruFilter(cp.getParts());
            try {
                List frus = ms.filter(dff);
                Iterator it = frus.iterator();
                while (it.hasNext()) {
                    ServiceableElement se = (ServiceableElement)it.next();
                    if (RepairAndVerifyTasklet.this.saType.equals("SET_SERVICE_LOCK")) {
                        se.setServiceLock(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("RESET_SERVICE_LOCK")) {
                        se.resetServiceLock(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("SET_IDENTIFY")) {
                        se.identify(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("RESET_IDENTIFY")) {
                        se.resetIdentify(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("FRU_LEVEL_ACTIVATE")) {
                        se.elementLevelActivate(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("SYSTEM_LEVEL_ACTIVATE")) {
                        se.systemLevelActivate(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("APPLICATION_LEVEL_ACTIVATE")) {
                        se.applicationLevelActivate(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("FRU_LEVEL_DEACTIVATE")) {
                        se.elementLevelDeactivate(userData);
                        continue;
                    }
                    if (RepairAndVerifyTasklet.this.saType.equals("SYSTEM_LEVEL_DEACTIVATE")) {
                        se.systemLevelDeactivate(userData);
                        continue;
                    }
                    if (!RepairAndVerifyTasklet.this.saType.equals("APPLICATION_LEVEL_DEACTIVATE")) continue;
                    se.applicationLevelDeactivate(userData);
                }
            }
            catch (Exception e) {
                Trace.trace(RepairAndVerifyTasklet.TRACE_MASKF, "<-! RepairAndVerifyTasklet.Utility, error: " + e);
                Trace.trace(RepairAndVerifyTasklet.TRACE_MASKF, e);
            }
        }

        public boolean isUpgradeData() {
            return false;
        }
    }
}

